Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      deq_tibrv.sql - Dequeues a message from MGWUSER.MGW_TIBRV_DEST.
Rem
Rem    DESCRIPTION
Rem      This script dequeues a message from queue MGWUSER.MGW_TIBRV_DEST.
Rem      If no message is available an exception is raised.
Rem

set serveroutput on;

declare
  dequeue_options        dbms_aq.dequeue_options_t;
  message_properties     dbms_aq.message_properties_t;
  msgid                  RAW(16);
  payload		 SYS.mgw_tibrv_msg_t;
  fieldCount             integer;
  field                  sys.mgw_tibrv_field_t;
  i                      integer;
BEGIN
  -- FIRST_MESSAGE
  dequeue_options.navigation := 1;
  dequeue_options.wait := dbms_aq.NO_WAIT;

  dbms_aq.dequeue(queue_name         => 'mgwuser.mgw_tibrv_dest',
                  dequeue_options    => dequeue_options,
                  message_properties => message_properties,
                  payload            => payload,
                  msgid              => msgid);

  dbms_output.put_line('A message is received from mgwuser.mgw_tibrv_dest.');
  dbms_output.put_line('Subject: ' || payload.get_send_subject());

  fieldCount := payload.get_field_count();

  for i in 1..fieldCount loop
      field := payload.get_field(i);
      if (field.field_type = dbms_mgwmsg.TIBRVMSG_DATETIME) then
          dbms_output.put_line('Field  ' || field.field_name || '   ' ||
                            to_char(field.date_value, 'YYYY-MM-DD HH24:MI:SS'));
      elsif (field.field_type = dbms_mgwmsg.TIBRVMSG_STRING) then
          dbms_output.put_line('Field  ' || field.field_name || '   ' ||
                            field.text_value);
      else
          raise_application_error(-20000, 'Unexpected message');
      end if;

  end loop;

  commit;
END dequeue;
/
